/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.client.screen.module.HeatingStructureSideInventoryScreen;
import slimeknights.tconstruct.smeltery.menu.HeatingStructureContainerMenu;

public class HeatingStructureScreen
extends MultiModuleScreen<HeatingStructureContainerMenu>
implements IScreenWithFluidTank {
    public static final class_2960 BACKGROUND = TConstruct.getResource("textures/gui/smeltery.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 76, 52, 52, 256, 256);
    private final HeatingStructureSideInventoryScreen sideInventory;
    private final HeatingStructureBlockEntity te;
    private final GuiSmelteryTank tank;
    public final GuiMeltingModule melting;
    private final GuiFuelModule fuel;

    public HeatingStructureScreen(HeatingStructureContainerMenu container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
        HeatingStructureBlockEntity te = (HeatingStructureBlockEntity)container.getTile();
        if (te != null) {
            this.te = te;
            this.tank = new GuiSmelteryTank(this, te.getTank(), 8, 16, HeatingStructureScreen.SCALA.w, HeatingStructureScreen.SCALA.h, Objects.requireNonNull(class_7923.field_41181.method_10221((Object)te.method_11017())));
            int slots = te.getMeltingInventory().getSlotCount();
            this.sideInventory = new HeatingStructureSideInventoryScreen(this, container.getSideInventory(), playerInventory, slots, HeatingStructureContainerMenu.calcColumns(slots));
            this.addModule(this.sideInventory);
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule(this, te.getMeltingInventory(), fuelModule::getTemperature, this.sideInventory::shouldDrawSlot);
            this.fuel = new GuiFuelModule(this, fuelModule, 71, 32, 12, 36, 70, 15, false);
        } else {
            this.te = null;
            this.tank = null;
            this.melting = null;
            this.fuel = null;
            this.sideInventory = null;
        }
    }

    protected void method_37432() {
        super.method_37432();
        if (this.te == null || !((Boolean)this.te.method_11010().method_11654((class_2769)ControllerBlock.IN_STRUCTURE)).booleanValue() || this.te.getMeltingInventory().getSlotCount() != this.sideInventory.getSlotCount()) {
            this.method_25419();
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(graphics, this, BACKGROUND);
        if (this.fuel != null) {
            this.fuel.draw(graphics, BACKGROUND);
        }
        super.method_2389(graphics, partialTicks, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderFluids(graphics);
        }
    }

    @Override
    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        assert (this.field_22787 != null);
        RenderUtils.setup(BACKGROUND);
        SCALA.draw(graphics, BACKGROUND, 8, 16);
        if (this.tank != null) {
            this.tank.renderHighlight(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(graphics, mouseX - this.field_2776, mouseY - this.field_2800);
        }
        if (this.melting != null) {
            this.melting.drawHeatBars(graphics, BACKGROUND);
        }
    }

    @Override
    protected void method_2380(class_332 graphics, int mouseX, int mouseY) {
        super.method_2380(graphics, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.drawTooltip(graphics, mouseX, mouseY);
        }
        if (this.fuel != null) {
            boolean hasTank = false;
            if (this.te.getStructure() != null) {
                hasTank = this.te.getStructure().hasTanks();
            }
            this.fuel.addTooltip(graphics, mouseX, mouseY, hasTank);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.tank != null) {
            this.tank.handleClick((int)mouseX - this.cornerX, (int)mouseY - this.cornerY);
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.cornerX;
        int checkY = (int)mouseY - this.cornerY;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngredient(checkX, checkY);
        }
        return ingredient;
    }
}

